
set more off
quiet: do "INDIVIDUAL 1b. Merge RILA.do"


* delete non-Catholic majority countries (Honduras, Uruguay)
drop if pctcatholics < .5

* delete non-Catholics
drop if QCURRELrec != 1


*===============================================================================
* Prepare Control Variables
*===============================================================================

* religiosity indicators
recode Q29 (1=4) (2=3) (3=2) (4=1) (5/.=.), gen(relimportant) // new
recode Q58 (1=7) (2=6) (3=5) (4=4) (5=3) (6=2) (7=1) (8/.=.), gen(freqpray) // new

* sex (female) // new
rename Q73 female
replace female = female-1

* age // new
recode Q74 (0/17=.) (98/.=.), gen(age)

* rural // new
rename Q114 rural
replace rural = rural-1

* political efficacy
* NOTHING AVAILABLE

* personal economic situation // new
recode Q2 (1=4) (2=3) (3=2) (4=1) (5/.=.), gen (personalecon)

* favor democracy to strong leader // new
recode Q17 (2=0) (3/.=.), gen (favordem)

* one true faith to heaven // new
recode Q33 (2/3=0) (4/.=.), gen (onetruefaith)

* interfaith activity // new
gen interfaith = .
replace interfaith = 1 if Q66c<5
replace interfaith = 0 if Q66c==5


*edu follows Blaydes and Lindzer 2012, p.235
*less than secondary, secondary-college/university (not finished), >=university
*local cty "ARG BOL BRA CHI COL CRI DOM ECU ESA GUA HON MEX NIC PAN PAR PER PUE URU VEN"
*set more off
*foreach icty of local cty {
*	labelbook Q80`icty'
*}
recode Q80ARG (1/4=1) (5/8=2) (9/10=3) (11/.=.)
recode Q80BOL (1/4=1) (5/8=2) (9/10=3) (11/.=.)
recode Q80BRA (1/5=1) (6/7=2) (8=3) (9/.=.)
recode Q80CHI (1/4=1) (5/8=2) (9/10=3) (11/.=.)
recode Q80COL (1/4=1) (5=2) (6/7=3) (8/.=.)
recode Q80CRI (1/6=1) (8=1) (7=2) (9/10=2) (11/14=3) (15/.=.)
recode Q80DOM (1/4=1) (5/7=2) (8/9=3) (10/.=.)
recode Q80ECU (1/5=1) (6/9=2) (10/11=3) (12/.=.)
recode Q80ESA (1/5=1) (6/8=2) (10=2) (12=2) (9=3) (11=3) (13/17=3) (18/.=.)
recode Q80GUA (1/5=1) (6=2) (7/9=3) (10/.=.)
recode Q80HON (1/4=1) (5/7=2) (8/9=3) (10/.=.)
recode Q80MEX (1/4=1) (5/8=2) (9=3) (10/.=.)
recode Q80NIC (1/4=1) (5/6=2) (7/11=3) (12/.=.)
recode Q80PAN (1/6=1) (7/10=2) (11/17=3) (18/.=.)
recode Q80PAR (1/8=1) (9/10=2) (11/12=3) (13/.=.)
recode Q80PER (1/2=1) (3/5=2) (6/7=3) (8/.=.)
recode Q80PUE (1/4=1) (5/6=2) (7/9=3) (10/.=.)
recode Q80URU (1/3=1) (4/7=2) (12=2) (8/11=3) (13/14=3) (15/.=.)
recode Q80VEN (1/4=1) (6=1) (5=2) (7/8=2) (9=3) (10/.=.)

*because for each respondent, values of other countries will be missing
egen edu = rowmin(Q80*)

* logging gdp per capita 2012
gen loggdppc = log(gdppc2012)


*===============================================================================
* Prepare bonding Questions
*===============================================================================

recode Q27d (1=5) (2=4) (4=2) (5=1) (6/.=.), gen(bonding1)



*===============================================================================
* Prepare Similarity Question (Catholics and Christians) and How Free Minorities Are
*===============================================================================
recode Q24 (1=0) (2=1) (3/.=.), gen(verydifferent)


*===============================================================================
* Standardize Non-Categorical Variables
*===============================================================================

egen zbonding1 = std(bonding1)

egen zfreqpray = std(freqpray)
egen zedu = std(edu)
egen zage = std(age)
*egen zefficacy = std(efficacy) NOT AVAILABLE
egen zpersonalecon = std(personalecon)

egen zloggdppc = std(loggdppc)
egen zpctcatholics = std(pctcatholics)
egen zGRI = std(GRI)
egen zpolity2 = std(polity2)
egen zrdi = std(rdi2010)

